<?php
/*
 * Big title section
 */
$mp_emmet_third_animation_left  = esc_attr( get_theme_mod( 'theme_third_animation_left', 'fadeInLeft' ) );
$mp_emmet_third_animation_right = esc_attr( get_theme_mod( 'theme_third_animation_right', 'fadeInRight' ) );
$mp_emmet_third_id_option       = esc_attr( get_theme_mod( 'theme_third_id' ) );
$mp_emmet_third_id              = empty( $mp_emmet_third_id_option ) ? 'third' : esc_attr( get_theme_mod( 'theme_third_id' ) );
?>
	<section id="<?php echo $mp_emmet_third_id; ?>" class="third-section grey-section">
		<div class="container">
			<div class="row">
				<?php if ( $mp_emmet_third_animation_left === 'none' ): ?>
					<div class="section-left third-left"></div>
				<?php else: ?>
					<div class="section-left third-left animated anHidden"
					     data-animation="<?php echo $mp_emmet_third_animation_left; ?>"></div>
				<?php endif; ?>

				<div class="col-xs-12 col-sm-7 col-md-7 col-lg-7 col-sm-offset-5 col-lg-offset-5 col-md-offset-5">
					<?php if ( $mp_emmet_third_animation_right === 'none' ): ?>
					<div class="section-content">
						<?php else: ?>
						<div class="section-content animated anHidden"
						     data-animation="<?php echo $mp_emmet_third_animation_right; ?>">
							<?php endif; ?>
							<?php
							$mp_emmet_third_title        = esc_html( get_theme_mod( 'theme_third_title' ) );
							$mp_emmet_third_description  = wp_kses( get_theme_mod( 'theme_third_description' ), mp_emmet_allowed_html() );
							$mp_emmet_third_button_label = esc_html( get_theme_mod( 'theme_third_button_label', __( 'read more', 'emmet-lite' ) ) );
							$mp_emmet_third_button_url   = esc_url( get_theme_mod( 'theme_third_button_url', '#' ) );
							if ( get_theme_mod( 'theme_third_title', false ) === false ) :
								?>
								<h2 class="section-title"><?php _e( 'Responsive Design', 'emmet-lite' ); ?></h2>
								<?php
							else:
								if ( ! empty( $mp_emmet_third_title ) ):
									?>
									<h2 class="section-title"><?php echo $mp_emmet_third_title; ?></h2>
									<?php
								endif;
							endif;
							if ( get_theme_mod( 'theme_third_description', false ) === false ) :
								?>
								<div
									class="section-description"><?php _e( 'Your content will automatically adapt to any screen size and look perfectly on all devices. Extend the boundaries of your web presence, create a website with full mobile support.', 'emmet-lite' ); ?></div>
								<?php
							else:
								if ( ! empty( $mp_emmet_third_description ) ):
									?>
									<div class="section-description"><?php echo $mp_emmet_third_description; ?></div>
									<?php
								endif;
							endif;
							?>
							<div class="section-buttons">
								<?php
								if ( ! empty( $mp_emmet_third_button_label ) && ! empty( $mp_emmet_third_button_url ) ):
									?>
									<a href="<?php echo $mp_emmet_third_button_url; ?>"
									   title="<?php echo $mp_emmet_third_button_label; ?>"
									   class="button"><?php echo $mp_emmet_third_button_label; ?></a>
									<?php
								endif;
								?>
							</div>
						</div>
					</div>
				</div>
			</div>
	</section>
<?php
