<?php
/*
 * subscribe section
 */
$mp_emmet_subscribe_animation_description = esc_attr( get_theme_mod( 'theme_subscribe_animation_description', 'fadeInLeft' ) );
$mp_emmet_subscribe_animation             = esc_attr( get_theme_mod( 'theme_subscribe_animation', 'fadeInRight' ) );
$mp_emmet_subscribe_id                    = esc_attr( get_theme_mod( 'theme_subscribe_id' ) );
$mp_emmet_subscribe_id                    = empty( $mp_emmet_subscribe_id ) ? 'subscribe' : esc_attr( get_theme_mod( 'theme_subscribe_id' ) );
?>
	<section id="<?php echo $mp_emmet_subscribe_id; ?>" class="subscribe-section default-section transparent-section">
		<div class="container">
			<div class="section-content">
				<?php
				$mp_emmet_subscribe_title       = esc_html( get_theme_mod( 'theme_subscribe_title' ) );
				$mp_emmet_subscribe_description = wp_kses( get_theme_mod( 'theme_subscribe_description' ), mp_emmet_allowed_html() );
				if ( get_theme_mod( 'theme_subscribe_title', false ) === false ) :
					?>
					<h2 class="section-title"><?php _e( 'newsletter form', 'emmet-lite' ); ?></h2>
					<?php
				else:
					if ( ! empty( $mp_emmet_subscribe_title ) ):
						?>
						<h2 class="section-title"><?php echo $mp_emmet_subscribe_title; ?></h2>
						<?php
					endif;
				endif;
				if ( get_theme_mod( 'theme_subscribe_description', false ) === false ) :
				?>
				<?php if ( $mp_emmet_subscribe_animation_description === 'none' ): ?>
				<div class="section-description">
					<?php else: ?>
					<div class="section-description animated anHidden"
					     data-animation="<?php echo $mp_emmet_subscribe_animation_description; ?>">
						<?php endif; ?>
						<?php _e( 'Use this section to display subscription form of any WordPress plugin or newsletter service', 'emmet-lite' ); ?></div>
					<?php
					else:
					if ( ! empty( $mp_emmet_subscribe_description ) ):
					?>
					<?php if ( $mp_emmet_subscribe_animation_description === 'none' ): ?>
					<div class="section-description">
						<?php else: ?>
						<div class="section-description animated anHidden"
						     data-animation="<?php echo $mp_emmet_subscribe_animation_description; ?>">
							<?php endif; ?>
							<?php echo $mp_emmet_subscribe_description; ?></div>
						<?php
						endif;
						endif;
						?>

						<?php if ( $mp_emmet_subscribe_animation === 'none' ): ?>
						<div>
							<?php else: ?>
							<div class=" animated anHidden"
							     data-animation="<?php echo $mp_emmet_subscribe_animation; ?>">
								<?php endif; ?>
								<?php
								/*
								 * mp_emmet_before_sidebar_subscribe hook
								 *
								 * @hooked mp_emmet_before_sidebar_subscribe - 10
								 */
								do_action( 'mp_emmet_before_sidebar_subscribe' );
								?>
								<?php
								if ( is_active_sidebar( 'sidebar-subscribe' ) ) :
									dynamic_sidebar( 'sidebar-subscribe' );
								else:
									?>
									<form method="POST" action="#" class="default-form">
										<div class="form-group">
											<input required="required" type="email" name="email"
											       placeholder="<?php _e( 'Your E-mail:', 'emmet-lite' ); ?>">
											<button class="btn btn-primary"
											        type="submit"><?php _e( 'subscribe', 'emmet-lite' ); ?></button>
										</div>
									</form>
								<?php endif;
								?>
								<?php
								/*
								 * mp_emmet_after_sidebar_subscribe hook
								 *
								 * @hooked mp_emmet_after_sidebar_subscribe - 10
								 */
								do_action( 'mp_emmet_after_sidebar_subscribe' );
								?>
								<div class='clearfix'></div>
							</div>
						</div>
					</div>
	</section>
<?php
 
