<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<?php do_action( 'vw_corporate_lite_above_slider' ); ?>

<?php /** slider section **/ ?>
	<?php
	// Get pages set in the customizer (if any)
	$pages = array();
	for ( $count = 1; $count <= 5; $count++ ) {
	$mod = absint( get_theme_mod( 'vw_corporate_lite_slidersettings-page-' . $count ));
	if ( 'page-none-selected' != $mod ) {
	  $pages[] = $mod;
	}
	}
	if( !empty($pages) ) :
	  $args = array(
	    'posts_per_page' => 5,
	    'post_type' => 'page',
	    'post__in' => $pages,
	    'orderby' => 'post__in'
	  );
	  $query = new WP_Query( $args );
	  if ( $query->have_posts() ) :
	    $count = 1;
	    ?>
		<div class="slider-main">
	    	<div id="slider" class="nivoSlider">
		      <?php
		        $vw_corporate_lite_n = 0;
				while ( $query->have_posts() ) : $query->the_post();
				  
				  $vw_corporate_lite_n++;
				  $vw_corporate_lite_slideno[] = $vw_corporate_lite_n;
				  $vw_corporate_lite_slidetitle[] = get_the_title();
				  $vw_corporate_lite_slidelink[] = esc_url(get_permalink());
				  ?>
				   <img src="<?php the_post_thumbnail_url('full'); ?>" title="#slidecaption<?php echo esc_attr( $vw_corporate_lite_n ); ?>" />
				  <?php
				$count++;
				endwhile;
				wp_reset_postdata();
		      ?>
		    </div>

		    <?php
		    $vw_corporate_lite_k = 0;
	      	foreach( $vw_corporate_lite_slideno as $vw_corporate_lite_sln )
	      	{ ?>
		      <div id="slidecaption<?php echo esc_attr( $vw_corporate_lite_sln ); ?>" class="nivo-html-caption">
		        <div class="slide-cap  ">
		          <div class="container">
		            <h2><?php echo esc_html($vw_corporate_lite_slidetitle[$vw_corporate_lite_k]); ?></h2>
		            <a class="read-more" href="<?php echo esc_url($vw_corporate_lite_slidelink[$vw_corporate_lite_k] ); ?>"><?php esc_html_e( 'Learn More','vw-corporate-lite' ); ?></a>
		          </div>
		        </div>
		      </div>
		        <?php $vw_corporate_lite_k++;
		    } ?>
		</div>
	  <?php else : ?>
	      <div class="header-no-slider"></div>
	    <?php
	  endif;
	endif;
?>

<?php do_action( 'vw_corporate_lite_above_services' ); ?>

<?php /*--OUR SERVICES--*/?>
<section id="our-services">
    <div class="container">    	
	    <div class="text-center innerlightbox">
	        <?php if( get_theme_mod('vw_corporate_lite_sec1_title') != ''){ ?>     
	            <h3><?php echo esc_html(get_theme_mod('vw_corporate_lite_sec1_title',__('OUR SERVICES','vw-corporate-lite'))); ?></h3>
	        <?php }?>
	        <?php if( get_theme_mod('vw_corporate_lite_sec1_subtitle') != ''){ ?>
	        <div class="subtitle"><?php echo esc_html(get_theme_mod('vw_corporate_lite_sec1_subtitle',__('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce vitae est at dolor auctor faucibus.','vw-corporate-lite'))); ?>
	        </div>
	        <?php }?>
	    </div>
	    <div class="row">
			<?php $pages = array();
				for ( $count = 0; $count <= 2; $count++ ) {
					$mod = intval( get_theme_mod( 'vw_corporate_lite_servicesettings-page-' . $count ));
					if ( 'page-none-selected' != $mod ) {
					  $pages[] = $mod;
					}
				}
				if( !empty($pages) ) :
				  $args = array(
				    'post_type' => 'page',
				    'post__in' => $pages,
				    'orderby' => 'post__in'
				  );
				  $query = new WP_Query( $args );
				  if ( $query->have_posts() ) :
				    $count = 0;
						while ( $query->have_posts() ) : $query->the_post(); ?>
							<div class="col-md-4">
								<div class="row">
									<div class="col-md-6 col-sm-6 textimage">
									    <div class="box-content text-center">
									    	<h3><?php the_title(); ?></h3>
									    	<p><?php $excerpt = esc_html( get_the_excerpt() ); echo esc_html(vw_corporate_lite_string_limit_words($excerpt,15)); ?></p>
									        <div class="clearfix"></div>
									        <a class="r_button hvr-sweep-to-right"  href="<?php the_permalink(); ?>"><?php esc_html_e('More','vw-corporate-lite'); ?></a>
									    </div>
									</div>
									<div class="col-md-6 col-sm-6">
									    <div class="box-image">
									        <img src="<?php the_post_thumbnail_url('full'); ?>"/>
									    </div>
								    </div>	
							    </div>
							</div>
						<?php $count++; endwhile; ?>
				  <?php else : ?>
				      <div class="no-postfound"></div>
				  <?php endif;
				endif;?>
			    <div class="clearfix"></div>
			</div>
		</div>
	</div> 
</section>

<?php do_action( 'vw_corporate_lite_above_content' ); ?>

<div class="container">
  <?php while ( have_posts() ) : the_post(); ?>
        <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
</div>

<?php get_footer(); ?>