<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package sshop
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'sshop' ); ?></a>

	<header id="site-header" class="site-header header-full" role="banner">
        <?php
        /**
         * Header
         *
         * @hooked sshop_site_brand - 10
         * @hooked sshop_nav_right - 15
         * @hooked sshop_nav - 20
         */
        do_action('sshop_header');
        ?>
	</header><!-- #site-header -->

	<div id="content" class="site-content">
